/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.GitRevList;
import com.aptana.git.core.model.GitRevSpecifier;
import com.aptana.git.ui.dialogs.CreateTagDialog;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CreateTagHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository theRepo = this.getSelectedRepository();
        if (theRepo == null && this.getSelectedResources() != null && this.getSelectedResources().isEmpty()) {
            this.openError(Messages.CommitAction_NoRepo_Title, Messages.CommitAction_NoRepo_Message);
            return null;
        }
        if (theRepo == null && this.getSelectedResources() != null && this.getSelectedResources().size() != 1) {
            this.openError(Messages.CommitAction_MultipleRepos_Title, Messages.CommitAction_MultipleRepos_Message);
            return null;
        }
        GitRevList revList = new GitRevList(theRepo);
        revList.walkRevisionListWithSpecifier(new GitRevSpecifier(new String[]{"."}), (IProgressMonitor)new NullProgressMonitor());
        CreateTagDialog dialog = new CreateTagDialog(this.getShell(), theRepo, revList.getCommits());
        if (dialog.open() == 0) {
            String tagName = dialog.getTagName().trim();
            String message = dialog.getMessage();
            String startPoint = dialog.getStartPoint();
            theRepo.createTag(tagName, message, startPoint);
        }
        return null;
    }
}

